<?php
/* --------------------------------------------------------------
 MiddlewareServiceProvider.php 2020-05-07
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

namespace Gambio\Admin\Application\Middleware;

use Gambio\Admin\Customer\SimpleCustomerService;
use Gambio\Core\Application\ServiceProviders\Abstraction\AbstractServiceProvider;
use Gambio\Core\Application\ValueObjects\Url;
use Gambio\Core\Application\ValueObjects\UserPreferences;
use Gambio\Core\Configuration\Builder\ConfigurationFinderBuilder;

/**
 * Class MiddlewareServiceProvider
 * @package Gambio\Admin\Application\Middleware
 */
class MiddlewareServiceProvider extends AbstractServiceProvider
{
    /**
     * @inheritDoc
     */
    public function provides(): array
    {
        return [
            AuthMiddleware::class,
            SecurityHeadersMiddleware::class
        ];
    }
    
    
    /**
     * @inheritDoc
     */
    public function register(): void
    {
        $authArgs = [
            SimpleCustomerService::class,
            UserPreferences::class,
            Url::class,
        ];
        $this->application->share(AuthMiddleware::class)->addArguments($authArgs);
        
        $this->application->share(SecurityHeadersMiddleware::class)->addArgument(ConfigurationFinderBuilder::class);
    }
}